// models database of employees
// uses switch statement for user choice

#include <iostream>
using namespace std;
const int SMAX = 21;      // maximum length of strings
const int EMAX = 100;     // maximum number of employees

struct employee
   {
      char name[SMAX];    // name (20 chars max)
      int serial_number;
   
      void input()        // get data from user
         {
         cout << "   Enter name: ";
         cin.get(name, SMAX);
         cout << "   Enter serial number: ";
         cin >> serial_number;
         }

      void output()       // display employee data
         {
         cout << "   Name = " << name;
         cout << "\n   Serial number = " << serial_number <<endl;
         }
   };

void main()
   {
   employee emps[EMAX];  // array of employee objects
   int n = 0;            // current number of objects in array
   int j;                // loop variable
   char choice = 'x';    // (ensure it's not 'q')

   while(choice != 'q')              // exit on 'q'
      {
      cout << "\n'a' to add an employee"
              "\n'd' to display all employees"
              "\n'q' to quit program"
              "\nEnter letter choice: ";
      cin >> choice;                  // get user's choice
      cin.ignore(10, '\n');          // eat extra '\n'

      switch(choice)
         {
         case 'a':                   // get employee data
            cout << "Enter data for employee " << (n+1) << endl;
            emps[n++].input();
            break;
         case 'd':                   // display all employees
            for(j=0; j<n; j++)
               {
               cout << "\nData for employee " << (j+1) << endl;
               emps[j].output();
               }
            break;
         case 'q':                   // let the while loop
            break;                   // terminate the program
         default:
            cout << "Unknown command";
            break;
         }  // end switch
      }  // end while
 }  // end main()

