// This program uses a structure pointer to dynamically allocate a structure 
// variable in memory. It is a modification of Program 11-1.
#include <iostream.h>
#include <iomanip.h>
#include <stdlib.h>

struct PayRoll
{
	int empNumber;			// Employee number
	char name[25];			// Employee's name
	float hours;			// Hours worked
	float payRate;			// Hourly Payrate
	float grossPay;			// Gross Pay
};

void main(void)
{
	PayRoll*  employee;		// Employee is a pointer to a 
					// PayRoll structure
	employee = new PayRoll;	              // Dynamically allocate a struct
	if (employee == NULL)	// Test the allocated memory
	{
		cout << "Memory allocation error!\n";
		exit(EXIT_FAILURE);
	}
	cout << "Enter the employee's number: ";
	cin >> employee->empNumber;
	cout << "Enter the employee's name: ";
	cin.ignore();	// To skip the remaining '\n' character
	cin.getline(employee->name, 25);
	cout << "How many hours did the employee work? ";
	cin >> employee->hours;
	cout << "What is the employee's hourly payrate? ";
	cin >> employee->payRate;
	employee->grossPay = employee->hours * employee->payRate;
 
	cout << "Here is the employee's payroll data:\n";
	cout << "Name: " << employee->name << endl;
	cout << "Number: " << employee->empNumber << endl;
	cout << "Hours worked: " << employee->hours << endl;
	cout << "Hourly Payrate: " << employee->payRate << endl;
	cout.precision(2);
	cout.setf(ios::fixed | ios::showpoint);
	cout << "Gross Pay: $" << employee->grossPay << endl;
	delete employee;  // Free the allocated memory
}