#include <iostream.h>
#include <iomanip.h>
#include <math.h>		// For the pow function

// Circle structure declaration

struct Circle
{
	float radius;
	float diameter;
	float area;
};

Circle getInfo(void);    // Function prototype

const float pi = 3.14159f; // Constant definition for Pi

void main(void)
{
	Circle c;	
	c = getInfo();
	c.area = static_cast<float>(pi * pow(c.radius, 2.0f));
	cout << "The radius and area of the circle are:\n";
	cout.precision(2);
	cout.setf(ios::fixed | ios::showpoint);
	cout << "Radius: " << c.radius << endl;
	cout << "Area: " << c.area << endl;
}

// Definition of function GetInfo. This function uses a
// local variable, Round, which is a Circle structure.
// The user enters the diameter of the circle, which is 
// stored in Round.Diameter. The function then calculates
// the radius, which is stored in Round.Radius. Round is then
// returned from the function.

Circle getInfo(void)
{
	Circle Round;
	cout << "Enter the diameter of a circle: ";
	cin >> Round.diameter;
	Round.radius = Round.diameter / 2;
	return Round;
}	
