// This program has a function that uses a structure reference variable
// as its parameter.

#include <iostream.h>

struct InvItem
{
	int partNum;			// Part number
	char description[50];    		// Item description
	int onHand;			// Units on hand
	float price;			// Unit price
};

// Function Prototypes

void GetItem(InvItem&);
void ShowItem(InvItem);
void main(void)
{
	InvItem part;
	GetItem(part);
	ShowItem(part);
}

// Definition of function GetItem. This function uses a structure reference
// variable as its parameter. It asks the user for information to store in the
// structure.

void GetItem(InvItem &piece)
{
	cout << "Enter the part number: ";
	cin >> piece.partNum;
	cout << "Enter the part description: ";
	cin.get();  // Eat the remaining newline
	cin.getline(piece.description, 50);
	cout << "Enter the quantity on hand: ";
	cin >> piece.onHand;
	
cout << "Enter the unit price: ";
	cin >> piece.price;
}

// Definition of function ShowItem. This function accepts an argument of
// the InvItem structure type. The contents of the structure is displayed. 

void ShowItem(InvItem piece)
{
	cout.precision(2);
	cout.setf(ios::fixed | ios::showpoint);
	cout << "Part Number: " << piece.partNum << endl;
	cout << "Description: " << piece.description << endl;
	cout << "Units On Hand: " << piece.onHand << endl;
	cout << "Price: $" << piece.price << endl;
}	
