// This program demonstrates a function that uses a
// pointer to a structure variable as a parameter.

#include <iostream.h>
#include <iomanip.h>

struct Student
{
	char name[35];			               // Student's name
	int idNum;				// Student ID number
	int crdHrs;				// Credit hours enrolled
	float gpa;				// Current GPA
};
 	
void getData(Student *);	// Function prototype

void main(void)
{
	Student freshman;
	cout << "Enter the following student data:\n";
getData(&freshman);
	cout << "\nHere is the student data you entered:\n";
	cout.precision(2);
	// Now display the data stored in Freshman
	cout << "Name: " << freshman.name << endl;
	cout << "ID Number: " << freshman.idNum << endl;
	cout << "Credit Hours: " << freshman.crdHrs << endl;
	cout << "GPA: " << freshman.gpa << endl;
}

// Definition of function GetData. Uses a pointer to a
// Student structure variable. The user enters student
// information, which is stored in the variable.
void getData(Student *s)
{
	cout << "Student Name: ";
	cin.getline(s->name, 35);
	cout << "Student ID Number: ";
	cin.ignore(); 			 // Ignore the leftover newline
	cin >> s->idNum;	
cout << "Credit Hours Enrolled: ";
	cin >> s->crdHrs;
	cout << "Current GPA: ";
	cin >> s->gpa;
}