// This program demonstrates that a pointer may be used as a 
// parameter to accept the address of an array. Either subscript
// or pointer notation may be used.
#include <iostream.h>
#include <iomanip.h>

// Function prototypes
void getSales(float *);
float totalSales(float *);

void main(void)
{      float sales[4];

	getSales(sales);
	cout.precision(2); //(in V4 this is, cout << setprecision(2);
	cout.setf(ios::fixed | ios::showpoint);
	cout << "The total sales for the year are $";
	cout << totalSales(sales) << endl;
}
// Definition of getSales. This function uses a pointer to accept
// the address of an array of four floats. The function asks the 
// user to enter the sales figures for four quarters, and stores
// those figures in the array. (The function uses subscript
// notation.)

void getSales(float *array)
{
	for (int count = 0; count < 4; count++)
	{
		cout << "Enter the sales figure for quarter ";
		cout << (count + 1) << ": ";
		cin >> array[count];
	}
}

// Definition of totalSales. This function uses a pointer to
// accept the address of an array of four floats. The function 
// gets the total of the elements in the array and returns that
// value. (Pointer notation is used in this function.)


float totalSales(float *array)
{
	float sum = 0.0;

	for (int count = 0; count < 4; count++)
	{
		sum += *array;
		array++;
	}
	return sum;
}	
