// This program totals and averages the sales figures for any
// number of days. The figures are stored in a dynamically
// allocated array.

#include <iostream.h>
#include <iomanip.h>

void main(void)
{
	float *sales, total = 0, average;
	int numDays;
cout << "How many days of sales figures do you wish ";
	cout << "to process? ";
	cin >> numDays;
	sales = new float[numDays];  // Allocate memory
	if (sales == NULL)  // Test for null pointer
	{
		cout << "Error allocating memory!\n";
		return;
	}
	// Get the sales figures from the user
	cout << "Enter the sales figures below.\n";
	for (int count = 0; count < numDays; count++)
	{
		cout << "Day " << (count + 1) << ": ";
		cin >> sales[count];
	}
	// Calculate the total sales
	for (count = 0; count < numDays; count++)
	{
		total += sales[count];
	}
	// Calculate the average sales per day
	average = total / numDays;
// Display the results
	cout.precision(2);
	cout.setf(ios::fixed | ios::showpoint);
	cout << "\n\nTotal sales: $" << total << endl;
	cout << "average sales: $" << average << endl;
	// Free dynamically allocated memory
	delete [] sales;
}	