function varargout = Image_Fusion_Demo(varargin)
% IMAGE_FUSION_DEMO MATLAB code for Image_Fusion_Demo.fig
%      IMAGE_FUSION_DEMO, by itself, creates a new IMAGE_FUSION_DEMO or raises the existing
%      singleton*.
%
%      H = IMAGE_FUSION_DEMO returns the handle to a new IMAGE_FUSION_DEMO or the handle to
%      the existing singleton*.
%
%      IMAGE_FUSION_DEMO('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in IMAGE_FUSION_DEMO.M with the given input arguments.
%
%      IMAGE_FUSION_DEMO('Property','Value',...) creates a new IMAGE_FUSION_DEMO or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Image_Fusion_Demo_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Image_Fusion_Demo_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Image_Fusion_Demo

% Last Modified by GUIDE v2.5 28-May-2014 18:45:25

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Image_Fusion_Demo_OpeningFcn, ...
                   'gui_OutputFcn',  @Image_Fusion_Demo_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Image_Fusion_Demo is made visible.
function Image_Fusion_Demo_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Image_Fusion_Demo (see VARARGIN)

% Choose default command line output for Image_Fusion_Demo
handles.output = hObject;

handles.wavelet = 'haar';
handles.approx = 'max';
handles.details = 'max';
handles.fscheck = 0;
% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Image_Fusion_Demo wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Image_Fusion_Demo_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in loadim_1.
function loadim_1_Callback(hObject, eventdata, handles)
% hObject    handle to loadim_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
image_file = uigetfile('*.*');
if ~isempty(image_file)
handles.im_original_1=imread(image_file);
handles.process_image_1 = rgb2hsv(handles.im_original_1);
set(handles.image_1,'HandleVisibility','ON');
axes(handles.image_1);
image(handles.im_original_1);
axis equal;
axis tight;
axis off;
set(handles.image_1,'HandleVisibility','OFF');
guidata(hObject, handles);
end;

% --- Executes on button press in loadim_2.
function loadim_2_Callback(hObject, eventdata, handles)
% hObject    handle to loadim_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
image_file = uigetfile('*.*');
if ~isempty(image_file) 
handles.im_original_2=imread(image_file);
handles.process_image_2 = rgb2hsv(handles.im_original_2);
set(handles.image_2,'HandleVisibility','ON');
axes(handles.image_2);
image(handles.im_original_2);
axis equal;
axis tight;
axis off;
set(handles.image_2,'HandleVisibility','OFF');
guidata(hObject, handles);
end;


% --- Executes on button press in loadim3.
function loadim3_Callback(hObject, eventdata, handles)
% hObject    handle to loadim3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
image_file = uigetfile('*.*');
if ~isempty(image_file)
handles.im_original_3 = imread(image_file);
handles.process_image_3 = rgb2hsv(handles.im_original_3);
set(handles.image_3,'HandleVisibility','ON');
axes(handles.image_3);
image(handles.im_original_3);
axis equal;
axis tight;
axis off;
set(handles.image_3,'HandleVisibility','OFF');
guidata(hObject, handles);
end;


% --- Executes on button press in exit.
function exit_Callback(hObject, eventdata, handles)
% hObject    handle to exit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close;

% --- Executes on selection change in approx_list.
function approx_list_Callback(hObject, eventdata, handles)
% hObject    handle to approx_list (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns approx_list contents as cell array
%        contents{get(hObject,'Value')} returns selected item from approx_list
appr =  get(hObject,'String');
index_selected = get(hObject,'Value');
handles.approx = appr{index_selected};
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function approx_list_CreateFcn(hObject, eventdata, handles)
% hObject    handle to approx_list (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'String',{'max';'min';'img1';'img2';'img3';'rand'});
end


% --- Executes on selection change in wav_list.
function wav_list_Callback(hObject, eventdata, handles)
% hObject    handle to wav_list (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns wav_list contents as cell array
%        contents{get(hObject,'Value')} returns selected item from wav_list
wavs =  get(hObject,'String');
index_selected = get(hObject,'Value');
handles.wavelet = wavs{index_selected};
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function wav_list_CreateFcn(hObject, eventdata, handles)
% hObject    handle to wav_list (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,hObject,'String',{'haar'
        ;'db1';'db2';'db3';'db4';
        'sym2';'sym3';'sym4';
        'coif1';'coif2';'coif3';'coif4';'coif5';
        'bior1.1';'bior1.3';'bior1.5';'bior2.2';'bior2.4';
        'rbio1.1';'rbio1.3';'rbio1.5';'rbio2.2';'rbio2.4'});
end


% --- Executes on selection change in details_list.
function details_list_Callback(hObject, eventdata, handles)
% hObject    handle to details_list (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns details_list contents as cell array
%        contents{get(hObject,'Value')} returns selected item from details_list
det =  get(hObject,'String');
index_selected = get(hObject,'Value');
handles.details = det{index_selected};
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function details_list_CreateFcn(hObject, eventdata, handles)
% hObject    handle to details_list (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'String',{'max';'min';'img1';'img2';'img3';'rand'});
end


% --- Executes on button press in fusion_button.
function fusion_button_Callback(hObject, eventdata, handles)
% hObject    handle to fusion_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Creating the chromatic components
fusion_im(:,:,1) = (handles.process_image_1(:,:,1) + handles.process_image_1(:,:,1) + handles.process_image_3(:,:,1)) / 3 ;
fusion_im(:,:,2) = (handles.process_image_1(:,:,2) + handles.process_image_1(:,:,2) + handles.process_image_3(:,:,2)) / 3 ;

handles = approx_details_check_1(handles);

%Fusing image 1 and 2
fus_1_2 = wfusimg(handles.process_image_1(:,:,3),handles.process_image_2(:,:,3),handles.wavelet,3,handles.approx,handles.details);

if handles.is3 ~= 1
 handles = approx_details_check_2(handles);
end

%Fusing the result of images 1 and 2 with image 3
fusion_im(:,:,3) = wfusimg(handles.process_image_3(:,:,3),fus_1_2,handles.wavelet,3,handles.approx,handles.details);

if handles.fscheck == 1 
    %Filtering and Sharpening the result
    fusion_im(:,:,3) = medfilt2(fusion_im(:,:,3),[3 3]);
    fusion_im(:,:,3) = imsharpen(fusion_im(:,:,3)); %Used in Matlab 2013a and
    %after

    %Alternative sharpening with worse results
    %alpha = 0.8; % Controls shape of filter - Between [0,1]
    %f = fspecial('unsharp', alpha); % Create mask
    %fusion_im(:,:,3) = imfilter(fusion_im(:,:,3), f); % Filter the image
end

%Return to RGB space and correcting the values of pixels
fusion_im = hsv2rgb(fusion_im);
fusion_im = fusion_im*255;
fusion_im = uint8(fusion_im);


fusion_im_to_handles(fusion_im, handles, hObject);

set(handles.synth_image,'HandleVisibility','ON');
axes(handles.synth_image);
image(fusion_im);
axis equal;
axis tight;
axis off;
set(handles.synth_image,'HandleVisibility','OFF');


% --- Executes on button press in save_button.
function save_button_Callback(hObject, eventdata, handles)
% hObject    handle to save_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[FileName, PathName] = uiputfile('*.tif', 'Save As'); %# <-- dot
Name = fullfile(PathName,FileName);  %# <--- reverse the order of arguments
imwrite(handles.fusion_im, Name, 'tiff');
if PathName==0, return; 
end

%Function used to get the result image into the handles struct
function fusion_im_to_handles(synth_im, handles, hObject)
handles.fusion_im = synth_im;
guidata(hObject, handles);

%Checking if approximation method is for image 3, in order to use right inputs to "wfusimg"
function modhandles1 = approx_details_check_1(modhandles1)
modhandles1.is3 = 1 ;
if strcmp(modhandles1.approx,'img3')
    modhandles1.approx = 'img1';
end
if strcmp(modhandles1.details,'img3')
    modhandles1.details = 'img1';
end

%Checking if approximation method is for image 1, in order to use right inputs to "wfusimg"
function modhandles2 = approx_details_check_2(modhandles2)
if strcmp(modhandles2.approx,'img1')
    modhandles2.approx = 'img2';
end
if strcmp(modhandles2.details,'img1')
    modhandles2.details = 'img2';
end


% --- Executes on button press in about_button.
function about_button_Callback(hObject, eventdata, handles)
% hObject    handle to about_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
about_fig;


% --- Executes on button press in filter_sharp_check.
function filter_sharp_check_Callback(hObject, eventdata, handles)
% hObject    handle to filter_sharp_check (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.fscheck = get(hObject,'Value') ;

guidata(hObject, handles);
