function P=DCT2basis(M);
% Find and display the 2D-DCT basis functions
M=8
DCT=cos(pi*[0:(M-1)]'*[1:2:(2*M-1)]/(2*M))*sqrt(2/M);DCT(1,:)=DCT(1,:)/sqrt(2);
X=zeros(M,M);
P=zeros(M*M,M*M);

for k=1:M
   for l=1:M
      X(k,l)=1;
      P((k-1)*M+1:k*M,(l-1)*M+1:l*M)=DCT'*X*DCT;
      X(k,l)=0;
   end;
end;

maxP=max(max(P)); minP=min(min(P));
PD= 255*(P-minP)/(maxP-minP);

figure;
whitebg('w');
for k=1:M
   for l=1:M
      subplot(M,M,(k-1)*M+l);
      image(PD((k-1)*M+1:k*M,(l-1)*M+1:l*M));
      daspect([1 1 1]); axis off;
      end;
end;
colormap(gray(255));
