% demo 4

% DCT transform and DCT basis function
% by definition
clc;
close all;
clear all;
M=8; 
C=cos(pi*[0:(M-1)]'*[1:2:(2*M-1)]/(2*M))*sqrt(2/M);C(1,:)=C(1,:)/sqrt(2);

% by using dct routine
% C2=dct(eye(8));
% 
% % Verify orthogonality
% C*C'
% C'*C
% 
% % Plot 1D basis function
% bplot(C);

% Plot 2D basis function
DCT2Dbasis(4);
4
DCT2Dbasis(8);
8
% DCT2Dbasis(16);
% 16
pause
%Plot frequency responses
frplot2(C);

% DCT & KLT transforms 
% comparing efficiency of these two transforms by experiment with AR(1) image

% how ar(1) looks like
y = ar1(0.95,512,512);
imshow(y/max(max(y)));

% Covariance matrix of AR(1) image. How to compute?
Rxx=toeplitz(0.95.^[0:(M-1)]');

% finding basis function of KLT by diagonalizing the covariance matrix using eigenvalue decomposition
[KLT,D]=eig(Rxx);

% KLT contains eigen vectors of covariance: basis functions of KLT
% transform
KLT=flipud(KLT');

% Verify diagonalization
KLT*Rxx*KLT'

% plot KLT basis functions in time domain
bplot(KLT);

% plot KLT basis functions in frequency domain
frplot2(KLT);

% plot DCT basis functions
figure;
bplot(C);

% compute coding gains of 2 transforms
% although KLT has bigger coding gain but in oder to compute KLT transform
% we have to know the covariance matrix which is not always feasible
% DCT has a very good approximation of KLT and require no knowledge of
% input statistics
gtcpu(KLT);

gtcpu(C);


% Apply block DCT to a real image
x=imread('lena.tif');
x = double(rgb2gray(x));
figure;imshow(x/256,'truesize');
help blkproc

% blockDCT is a subroutine that returns DCT coefficients of a given image
% block and then uniformly quantizes these coefficients
% quantization step size = 16
fun = @blockDCT; % look at blockDCT definition
y=blkproc(x,[8 8],fun,C,16);
ccount(y)
figure;imshow(y/max(max(y)),'truesize');

% blockIDCT is a subroutine that returns IDCT coefficients of a given image
% block and then dequantize these coefficients
fun = @blockIDCT; % look at blockIDCT definition
xr=blkproc(y,[8 8],fun,C,16);
figure;imshow(xr/256,'truesize');
imgpsnr(x,xr);

% now combine fundamental blocks of a communication system: 
% DCT transform, Quantization, Entropy Coding( Huffman coding)
% Problem formulation: given a file( e.g an image), how a communication
% system processes that file before transfering it over the channel ?

% input the image
x=imread('lena.tif');
x = double(rgb2gray(x));
figure;imshow(x/256,'truesize');

%  DCT-transform that image and then uniformly quantize
% quantization step size = 16
fun = @blockDCT;  % look at blockDCT definition
y=blkproc(x,[8 8],fun,C,16);
% ccount(y)
% figure;imshow(y/max(max(y)),'truesize');


% Huffman coding
[v h] = size(y);
y1 = reshape(y,1,v*h);y1 = double(y1);

% process negative values of quantized DCT coefficients
miny1  = min(y1);
y1 = y1-min(y1);

% compute frequency of occurence
freq = hist(y1,0:max(y1)); freq = freq / sum(freq);

% creating huffman table
[table tblshow] = huff_tbl(freq');

% encode
yh = huff_enc_l(table,y1);

% compute efficiency of the system
[vx hx] = size(x);
l = vx*hx
lh = length(yh)/8

l/lh

% decode
yr = huff_dec_l(table,yh);

% shift back to true values
yr = yr + miny1;
yr = reshape(yr, v, h);

% check that huffman coding is lossless operation
sum(sum(double(y)-yr))

%  de-quantize and invert transform to recover the original image 
fun = @blockIDCT;  % look at blockIDCT definition
xr=blkproc(yr,[8 8],fun,C,16);
figure;imshow(xr/256,'truesize');
imgpsnr(x,xr);

