function y=ar1(p,M,N);
% y=ar1(p,m,n); 1D version
% Function to generate an AR(1) M x N image with autocorrelation coefficient p

%Generate zero-mean unit-variance random Gaussian noise
w=random('normal',0,1,[1 M*N]); y=zeros(1,M*N); y(1)=p*w(1)+w(1);

for k=2:M*N 
    y(k) = p*y(k-1) + w(k); 
end;
y=reshape(y,M,N);

%Make sure that output fits the popular possitive 8-bit natural image range
y = y - min(min(y));
y=round(255*y/max(max(abs(y))));