function [H,F]=MLT(M);
% [H,F]=MLT(M);
% Function to compute the M x 2M MLT basis functions
% M: number of channel; must be even.
% H: Mx2M analysis transform matrix.
% F: Mx2M synthesis transform matrix.
%
% Prof. Trac D. Tran
% Department of Electrical and Computer Engineering
% The Johns Hopkins University
% 06/04/2002

Ha=-sin((ones(M,1)*[0:2*M-1] + 1/2)*pi/2/M); %analysis window
%Ha=-ones(M,2*M); %box window
Hs=Ha; %synthesis window
H=sqrt(2/M)*Ha.*cos([1/2:1/2+M-1]'*[(M+1)/2:(5*M-1)/2]*pi/M);
F=sqrt(2/M)*Hs.*cos([1/2:1/2+M-1]'*[(M+1)/2:(5*M-1)/2]*pi/M);

% Plot time and frequency responses
bplot2(H,F);
afrplot(H,F);
