function psnr = imgpsnr(img1, img2)
% Calculate the PSNR between two images
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Author:	Jie Liang
%
% Created:	Nov. 20, 1999
%
% Input:
%	img1:   	data of the first image,
%  img2:    data fo the second image,
%	row:		Number of rows of the image,
%	col:		Number of Columns of the image,
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

err= abs(img1 - img2);
maxerr = max(max(err));
s=sprintf('Max error: %d', maxerr);disp(s);

err = err .^ 2;
mse = sum(sum(err)) / size(img1,1) / size(img1,2);
psnr = 10 * log10(255*255/mse);
s=sprintf('PSNR:%f dB',psnr);disp(s);

