function y=huff_enc(table,x)
% Usage: y=huff_enc(table,x)
% huffman encoding algorithm
% table: p by dmax+1 matrix. Last column consists of length of code
%    1st to 2nd last column is the  actual code (by row)
%        huffman table is generated by huff_tbl
% x: input stream.  N x 1 vector. Assume each element is an integer
%    between 1 and p.  
% y: row vector, output stream.  Length unknown.  consists of 0 and 1.

% Yu Hen Hu (copyright 1996)
% Last revision: 2/6/1996
%
N=length(x);
[p,dm1]=size(table);
depth=table(:,dm1);
y=zeros(1,length(x)*8);
l = 1;
for i=1:N,
   y(l:l+depth(x(i)+1)-1) = table(x(i)+1,1:depth(x(i)+1));
   l = l+depth(x(i)+1);
end
y = y(1:l-1);