function x=huff_dec(table,y)
% Usage: x=huff_dec(table,y)
% huffman decoding algorithm
% table: p by dmax+1 matrix. Last column consists of length of code
%    1st to 2nd last column is the  actual code (by row)
%        huffman table is generated by huff_tbl
% x: output symbol stream. Each element is an integer
%    between 1 and p.  
% y: row vector, input binary stream.  
% Yu Hen Hu (copyright 1996)
% Last revision: 2/6/1996
%

N=length(y);
[p,dm1]=size(table);
depth=table(:,dm1);
x=y;
mark=0;  % mark= 1 is the end of a binary stream corresponding
         % to a symbol.
i=1; d=1;tmp=ones(p,1);
l = 1;
while i<=N,
   % match y(i) to that of the d-th bit in the table
   tmp=tmp.*[table(:,d)==y(i)]; % tmp is a vector of 0 and 1
              % with 1 indicate a match
   if sum(tmp)==1,  % narrow down to one symbol, find it
      [isort,idx]=sort(tmp);  % after sorting, index of 
      x(l) = idx(p)-1; % the 1 location is at the last element.
      l = l+1;
      mark=1;       % indicating a new symbol is decoded.
      d=1;          % reset pointer to columns of table.
      tmp=ones(p,1);
      % otherwise, continue to match the next column in table
   elseif d < max(depth)
      d=d+1; mark=0;
   end
   i=i+1; 
end
x = x(1:l-1);