function sx=dwtscale(x,L);
% sx=dwtscale(x,L);
% Scaling 2D wavelet coefficients for display purposes
% Emphasize the high-frequency coefficients to make them more visible
%
% x: input wavelet coefficients
% L: number of decomposition levels
% sx: scaled coefficients 
%
% Trac D. Tran
% NAWCWD
% 07/31/2002

[m,n]=size(x);
sx=x;
m=m/(2^L);n=n/(2^L);
sx(1:m,1:n)=255*abs(x(1:m,1:n))/max(max(abs(x(1:m,1:n))));
for i=1:L
	sx(1:m,n+1:2*n)=255*abs(x(1:m,n+1:2*n))/max(max(abs(x(1:m,n+1:2*n))));
    sx(m+1:2*m,1:n)=255*abs(x(m+1:2*m,1:n))/max(max(abs(x(m+1:2*m,1:n))));
    sx(m+1:2*m,n+1:2*n)=255*abs(x(m+1:2*m,n+1:2*n))/max(max(abs(x(m+1:2*m,n+1:2*n))));
	m=m*2;n=n*2;
end;
