function demo;
% 520.643 DCT demo

% DCT transform matrix
M=8; C=cos(pi*[0:(M-1)]'*[1:2:(2*M-1)]/(2*M))*sqrt(2/M);C(1,:)=C(1,:)/sqrt(2);
C2=dct(eye(8));

% Verify orthogonality
C*C'
C'*C

% Plot 1D basis
bplot(C);

% Plot 2D basis
DCT2Dbasis(4);
DCT2Dbasis(8);

%Plot frequency responses
frplot2(C);

% DCT Approaching KLT
Rxx=toeplitz(0.95.^[0:(M-1)]');
[KLT,D]=eig(Rxx);
KLT=flipud(KLT');
bplot(KLT);
frplot2(KLT);
figure;
bplot(C);
KLT*Rxx*KLT'
C*Rxx*C'

% Basis sensitivity - JND design
jnd(8,8,5);

% Apply block DCT to an image
x=imread('lena.tif');x=double(x);
figure;imshow(x/256,'truesize');
help blkproc
fun = @blockDCT;
y=blkproc(x,[8 8],fun,C,16);
ccount(y)
figure;imshow(y/max(max(y)),'truesize');
fun = @blockIDCT;
xr=blkproc(y,[8 8],fun,C,16);
figure;imshow(xr/256,'truesize');
imgpsnr(x,xr);
