function [gdb,Ryy]=bgtc(H,G);
% [gdb,Ryy]=bgtc(H,G);
% Function to calculate the coding gain of a biorthogonal PRFB
% Rows of H hold the analysis filter coefficients
% Rows of G hold the synthesis filter coefficients

[m,n]=size(H);
Rxx=toeplitz(0.95.^[0:(n-1)]');
Ryy=H*Rxx*H';
s=diag(Ryy);
% g=mean(s)/(prod(s)^(1/m));
% g=1/((prod(s.*sqrt(diag(G*G'))))^(1/m));
g=1/((prod(s.*diag(G*G')))^(1/m));
gdb=10*log10(g);

