function afrplot(P,G);
% Function to plot the frequency response of the analysis FB as well as  
% its coding gain, DC attenuation, frequency attenuation, and mirror
% frequency attenuation

[M,L]=size(P);
F=abs(fft(P',512));
F=(F+(F<1e-20)*1e-20)';
F=20*log10(F(:,1:256)/F(1,1));
DC=max(F(2:M,1));
F=max(-50,F);
N=256/M;bis=2*N+1;

[tmp,imax]=max(F');
Fdiff=F-[F(:,1) F(:,1:255)];smax=-50;
for i=1:M
   iright=find(Fdiff(i,imax(i):256)>3);
   if ~isempty(iright) %iright~=[]
      iright=iright(1);
      smax=max(smax,max(F(i,imax(i)+iright:256)));
   end;
   ileft=find(fliplr(Fdiff(i,1:imax(i)))<-3);
   if ~isempty(ileft) %ileft~=[]
      ileft=ileft(1);
      smax=max(smax,max(F(i,1:imax(i)-ileft)));
   end;
end;

x=0:1/512:.5-1/512;
figure
plot(x,F');
axis([0 0.5 -40 2]);
set(gca,'fontsize',7);
title(['DC Att. >= ',num2str(-DC,2),' dB   Mirr Att. >= ',...
num2str(-mirrfreq(P),2),' dB   Stopband Att. >= ',num2str(-smax,2),...
' dB   Cod. Gain = ',num2str(bgtc(P,G),2),' dB']);
tt=get(gca,'title');set(tt,'fontsize',8);
xlabel('Normalized Frequency');
xl=get(gca,'xlabel');set(xl,'fontsize',8);
ylabel('Magnitude Response (dB)');
yl=get(gca,'ylabel');set(yl,'fontsize',8);
grid on;
