%This script shows how to perform linear filtering directly in the Fourier domain.
%by Lin ZHANG, SSE, Tongji University, Shanghai, China, Feb. 2013
im = imread('NP.jpg');
figure (1)
imshow(im), title(' original image')
[rows, cols] = size(im);
%pad the image to its double size by populating zeros
paddedIm = padarray(im, [rows, cols],'post');
figure (2)
imshow(paddedIm), title(' padded image')
imfft = fft2(paddedIm);
imfftShifted = fftshift(imfft);
figure (3)
imshow(imfftShifted), title(' imfft Shifted image')
%construct a low-pass filter (of a Gaussian shape) in the Fourier domain
sigmaInFourierDomain = 100;
filterInFourierDomain =  fspecial('gaussian', [rows*2, cols*2], sigmaInFourierDomain);
modifiedFourierTransform = ifftshift(imfftShifted.*filterInFourierDomain);

%go back to the spatial domain
resultInSpatialDomain = real(ifft2(modifiedFourierTransform));

%extract the final processed result 
finalResult = resultInSpatialDomain(1:rows, 1:cols);
figure (4);
imshow(finalResult,[]);
title(' Final image')


