

#include <stdio.h> // Εισαγωγή της βιβλιοθήκης standard input/output για να δουλέψει η printf

int main()
{
    // --- Βήματα 1, 2, 3: Ορισμός και Αρχικοποίηση Μεταβλητών ---

    // 1. Ορίζω μια ακέραια μεταβλητή (int) και της δίνω μια τυχαία τιμή [cite: 12]
    int test = 23;

    // 2. Ορίζω μια μεταβλητή κινητής υποδιαστολής (float) με τυχαία τιμή [cite: 13]
    float pragm = 32.32;

    // 3. Ορίζω έναν χαρακτήρα (char) και τον αρχικοποιώ [cite: 14, 15]
    char gramma = 'a';


    // --- Βήμα 6: Ορισμός Δεικτών 
    // Εδώ αποθηκεύω τις διευθύνσεις μνήμης των παραπάνω μεταβλητών σε pointers [cite: 18]
    
    char *grammaPtr = &gramma; // Δείκτης που δείχνει στη διεύθυνση του char
    int *testPtr = &test;      // Δείκτης που δείχνει στη διεύθυνση του int
    float *pragmPtr = &pragm;  // Δείκτης που δείχνει στη διεύθυνση του float


    // --- Βήματα 5 & 6: Εκτυπώσεις Μεγεθών και Διευθύνσεων ---
    
    // Εκτυπώνω το μέγεθος (με sizeof) και τη διεύθυνση (με &) της ακέραιας μεταβλητής test [cite: 17, 18]
    // Χρησιμοποιώ %lu για το sizeof (unsigned long) και %p για τη διεύθυνση μνήμης
    printf("Η μεταβλητή test έχει μέγεθος %lu bytes και διεύθυνση:%p\n", sizeof(test), &test);

    // Εκτυπώνω το μέγεθος και τη διεύθυνση της float μεταβλητής pragm
    // Εδώ κάνω cast το sizeof σε int (%d) όπως φαίνεται στο δικό σου κώδικα
    printf("Η μεταβλητή pragm εχει μέγεθος %d bytes και διεύθυνση: %p\n", (int)sizeof(pragm), &pragm);

    // Εκτυπώνω το μέγεθος και τη διεύθυνση της char μεταβλητής gramma
    // Εδώ χρησιμοποιώ τον pointer (grammaPtr) για να δείξω τη διεύθυνση, αντί για το &gramma
    printf("Η μεταβλητή gramma έχει μέγεθος %lu bytes και διεύθυνση:%p (pointer)\n", sizeof(gramma), grammaPtr);

    
    
    // Εδώ τυπώνω το μέγεθος που πιάνει ο ίδιος ο δείκτης στη μνήμη και τη δική του διεύθυνση
    printf("Η μεταβλητή grammaPtr έχει μέγεθος %lu bytes και διεύθυνση:%p\n", sizeof(grammaPtr), &grammaPtr);
    
    printf("Η μεταβλητή testPtr έχει μέγεθος %lu bytes και διεύθυνση:%p (pointer)\n", sizeof(testPtr), testPtr);
    
    printf("Η μεταβλητή pragmPtr έχει μέγεθος %lu bytes και διεύθυνση:%p (pointer)\n", sizeof(pragmPtr), pragmPtr);

    return 0; // Τυπική επιστροφή για την main 
}