function [vMin,theBestVct,Convergence_curve,Var_Hist]=MSO(SearchAgents_no,Max_iter,lb,ub,dim,fobj)
Positions=MSO_Init(SearchAgents_no,dim,ub,lb); 
for i=1:size(Positions,1)
      Fitness(i,1)=fobj(Positions(i,:)); % get fitness     
 end
Convergence_curve=zeros(1,Max_iter);
Var_Hist=zeros(Max_iter,dim);
[vMin, minIdx]= min(Fitness);
theBestVct= Positions(minIdx,:);
Polarization= randi([1, 3], 1, SearchAgents_no);
Vel_max=80;
% ::: Main loop :::::::::::::::::::::::::::::::::::
for t=1:Max_iter   
    Convergence_curve(t)= vMin;
        for i=1:size(Fitness,1) 
           if Polarization(i)==1  % Strategy 1: Foraging, Eq. 12 in the paper
            r=randi(size(Fitness,1),1);
            while i==r
                r=randi(size(Fitness,1),1);
            end
            D=-1+2.*rand;
            x(i,:)=(theBestVct-Positions(i,:))+D.*(Positions(r,:)-theBestVct);
           
           elseif Polarization(i)==2  % Strategy 2: Attack Eq. 14 in the paper
            tt=180+(360-180).*rand;
            x(i,:)=theBestVct.*cos(tt); 
            
           elseif Polarization(i)==3 % Strategy 3: Burrow, Defense, or Shelter, Eq. 15 in the paper
            k=0+(0.3-0).*rand;
            bin=((-1).^randi(2));
            x(i,:)=theBestVct+rand.*bin.*k.*theBestVct;
            if bin==1
                tt=180+(360-180).*rand; 
                x(i,:)=x(i,:).*cos(tt);
            end            
        end
% ::::::::::::::::::::   
    % Return the search agents that go beyond the boundaries of the search space.
        Flag4ub=x(i,:)>ub;             
        Flag4lb=x(i,:)<lb;
        x(i,:)=(x(i,:).*(~(Flag4ub+Flag4lb)))+(Flag4ub+Flag4lb).*(lb+rand(1,dim).*(ub-lb));
     end
% ::::::::::::::::::::
    Polarization= getPolarization( Positions,Fitness,x,SearchAgents_no);
    Positions=x;
    %Calculate the fitness value from the new population
    for i=1:size(Positions,1)
      Fit(i,1)=fobj(Positions(i,:));      
    end
    [VMin ,MinIdx]= min(Fit);    
    % Update the fitness and the best solution found
    if VMin<vMin 
        theBestVct= Positions(MinIdx,:);
        vMin=VMin;
    end
    Fitness=Fit;
    Var_Hist(t,:)=theBestVct;    
    outmsg = ['Iter.# ',num2str(t),'   Best so far = ', num2str(vMin)];disp(outmsg);       
    
end
end
