clc; clear; close all;
System_Init; % Set the system data
% Search variables boundaries
%-------------------------------------------------------------------
% CASE of PIDF
%     Kp1 Ki1 Kd1  N1  Kp2 Ki2 Kd2  N2  Ps K2 K4  K5 K6
lb = [ -3  -3  -3   0   -3  -3  -3   0   0  0  0  -1  0];
ub = [  3   3   3 300    3   3   3 300   3  3  3   1  3];
dim = 13;
%-------------------------------------------------------------------
% CASE of 2DOFPID
%       Kp1 Ki1 Kd1  N1 b1 c1 Kp2 Ki2 Kd2  N2 b2 c2 Ps K2 K4  K5 K6
% lb = [ -3  -3  -3   0  0  0  -3  -3  -3   0  0  0  0  0  0  -1  0];
% ub = [  3   3   3 300  5  5   3   3   3 300  5  5  3  3  3   1  3];
% dim = 17;
%-------------------------------------------------------------------
overallBestObj=inf; bestRun=0; totalsimtime=0;
% Algorithm parameters
Runs = 2;        % Independent experiments no. - Set to 10
Pop  = 5;        % Number of search agents     - Set to 80
Iter = 10;       % Total number of iterations  - Set to 100
fobj = @ObjF;
%% -------------------------------------------------------------------
NoWolves=Pop;
Max_iteration=Iter;
for i=1:Runs
disp('-----------------------------------------------------');
disp('hSMG Stability and Control - GWO');
disp(['Run No : ', num2str(i)]);
tic;
[Best_score,Best_pos,GWO_cg_curve,Var_History]=GWO(NoWolves,Max_iteration,lb,ub,dim,fobj);
simtime=toc; totalsimtime=totalsimtime+simtime;
% Display results
disp(['Summary of Run No      : ', num2str(i)]);
disp( 'Best solution obtained :');
display(num2str(Best_pos));
disp(['Best obj.fun. value    : ', num2str(Best_score)]);
disp(['Sim. time so far       : ', num2str(totalsimtime/3600),' hrs.']);
%disp('-----------------------------------------------------');
if Best_score<overallBestObj
   overallBestObj=Best_score;
   bestRun=i;
end
% Save optimal results
cgcurve=GWO_cg_curve;
bestObj=Best_score;
bestGains=Best_pos;
Var_Hist=Var_History;
if i<10 
 filename=strcat('GWO-results0',num2str(i),'.mat');
else
 filename=strcat('GWO-results' ,num2str(i),'.mat');    
end
save(filename,'bestGains','bestObj','cgcurve','Var_Hist','simtime','totalsimtime');
end
disp('=====================================================');
disp(['Best Run was No    : ', num2str(bestRun)]);
disp(['Best obj.fun. value: ', num2str(overallBestObj)]);
disp(['Total Sim. time    : ', num2str(totalsimtime/3600),' hrs.']);
disp('====== All independent experiments completed ! ======');